#include "SimRobot.h"
#include "RobotMotorControlCommand.h"

namespace SimulationEngine
{

SimRobot::SimRobot()
{
	
}

SimRobot::SimRobot(DataRobot data): ISimEntity(data.GetDataEntityId())
{
	referencebody = 0;
	IPhysicsController *physics = PhysicsControllerFactory::GetInstance()->GetPhysicsController();
	std::list<DataObject*>::iterator iter;
	list<DataObject *> structure =data.GetStructure(); 	
	for(iter=structure.begin(); iter!=structure.end();iter++)	
	{
		if (DataBody *databody = dynamic_cast<DataBody *>(*iter))
		{
			IPhysicalBody *body = physics->CreatePhysicalBody(data.GetDataEntityId(), databody);
			bodies.insert(make_pair(databody->GetBodyId(),body));

			if (databody->GetBodyId()== data.GetReferenceBodyId())
			{
				referencebody = body;
			}
		}	
		else if (DataJoint *datajoint = dynamic_cast<DataJoint *>(*iter))
		{
			IPhysicalBody *body1 = bodies.find(datajoint->GetIdBody1())->second;
			IPhysicalBody *body2 = bodies.find(datajoint->GetIdBody2())->second;
			joints.insert(make_pair(datajoint->GetJointId(),physics->CreatePhysicalJoint(datajoint, body1, body2)));

		}	
		
	}
	
	
	std::list<int>::iterator iter2;		
	std::list <int> motorslist =data.GetMotors(); 
	iter2 = motorslist.begin();
	while (iter2!=motorslist.end())
	{
		IPhysicalJoint *joint = joints.find(*iter2)->second;
		motors.insert(make_pair(*iter2, joint));
		iter2++;
	}
	
	RobotMotorControlCommand *cmd = new RobotMotorControlCommand(this);
	this->AddCommand(cmd);
}

SimRobot::~SimRobot()
{
	std::map<int, IPhysicalBody*>::iterator iter;
	iter = bodies.begin();
	while (iter!=bodies.end())
	{
		IPhysicalBody *todestroy = iter->second;
		delete todestroy;
		iter++;
	}
	std::map<int, IPhysicalJoint*>::iterator iter2;
	iter2 = joints.begin();
	while (iter2!=joints.end())
	{
		IPhysicalJoint *todestroy = iter2->second;
		delete todestroy;
		iter2++;
	}
}

string SimRobot::GetSimString()
{
	string ret = "<Robot_Entity><Entity_Id>";
	stringstream id;
	id<< this->GetEntityId();
	ret+= id.str();
	ret+= "</Entity_Id>";
	Vector3f pos = referencebody->GetPosition();
	Vector3f rot = referencebody->GetRotation();
	ret += pos.ToString("Position_X","Position_Y","Position_Z")+
		   rot.ToString("Rotation_X","Rotation_Y","Rotation_Z")+"</Robot_Entity>";
	return ret;
}

map<int, IPhysicalJoint *> SimRobot::GetMotors()
{
	return motors;
}

void SimRobot::SetEntityPosition(float posx, float posy, float posz)
{
	referencebody->UpdateData();
	Vector3f positionref = referencebody->GetPosition();
	float difx = positionref.GetFirst()-posx;
	float dify = positionref.GetSecond()-posy;
	float difz = positionref.GetThird()-posz;
	referencebody->SetPhysicalPosition(posx,posy,posz);
	map<int, IPhysicalBody *>::iterator iter;
	iter = bodies.begin();
	while (iter!=bodies.end())
	{
		if (iter->second!=referencebody)
		{
			iter->second->UpdateData();
			Vector3f positionbody = iter->second->GetPosition();
			iter->second->SetPhysicalPosition(positionbody.GetFirst()-difx,positionbody.GetSecond()-dify,positionbody.GetThird()-difz);
		}
		iter++;
	}
	
	
	
}

string SimRobot::PersistEntity()
{
	string toreturn = "<Entity Type=\"Robot\"><Entity_id>";
	stringstream entityid;
	entityid<<this->GetEntityId();
		
	toreturn+= entityid.str()+ "</Entity_id><Bodies>";
	map<int, IPhysicalBody *>::iterator iterbodies;	
	iterbodies = bodies.begin();
	while (iterbodies!=bodies.end())
	{
		iterbodies->second->UpdateData();
		toreturn += iterbodies->second->GetDataBody()->ToString();
		iterbodies++;
	}
	toreturn+="</Bodies><Joints>";
	map<int, IPhysicalJoint *>::iterator iterjoints;	
	iterjoints = joints.begin();
	while (iterjoints!=joints.end())
	{
		iterjoints->second->UpdateData();
		toreturn += iterjoints->second->GetDataJoint()->ToString();
		iterjoints++;
	}
	toreturn+="</Joints><Motors>";
	
	map<int, IPhysicalJoint *>::iterator itermotors;
	itermotors = motors.begin();
	while (itermotors!=motors.end())
	{
		stringstream motornumb;
		motornumb<< itermotors->first;
		toreturn+="<Motor>"+motornumb.str()+"</Motor>";
		itermotors++;
	}
	stringstream ref;
	ref<< referencebody->GetObjectId();
	toreturn += "</Motors><Reference_Body>" +ref.str()+"</Reference_Body></Entity>";
	return toreturn;
}

}
